<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DeliveryNoticeController;
use \App\Http\Controllers\RedeliveryController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

// 不在連絡票
Route::get('delivery_notice/{redelivery}', [DeliveryNoticeController::class, 'show']);

// 再配達依頼
Route::get('redelivery/{redelivery:uuid}', [RedeliveryController::class, 'edit'])->name('redelivery.edit');
Route::put('redelivery/{redelivery:uuid}', [RedeliveryController::class, 'update'])->name('redelivery.update');


