<?php

namespace App\Http\Controllers;

use App\Models\SplitTesting;
use Illuminate\Http\Request;

class SplitTestingController extends Controller
{
    public function top() {

        $views = [
            'split_testing.black_friday_sale_a',
            'split_testing.black_friday_sale_b'
        ];

        return view('split_testing')->with([
            'views' => $views
        ]);

    }

    public function sale(Request $request) {

        if($request->filled('split_testing')) {

            $split_testing_name = $request->split_testing;
            $cookie_key = 'split_testing_'. $split_testing_name;

            if(\Cookie::has($cookie_key)) {

                $cookie_data = json_decode(
                    \Cookie::get($cookie_key)
                );
                $view_index = $cookie_data->index;
                $uuid = $cookie_data->uuid;

                $split_testing = SplitTesting::where('name', $split_testing_name)
                    ->where('view_index', $view_index)
                    ->where('uuid', $uuid)
                    ->first();

                if(!is_null($split_testing)) {

                    $split_testing->accessed = true;
                    $split_testing->save();

                }

            }

        }

        return 'セール中です！';

    }
}
