<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class CashRegisterController extends Controller
{
    public function index() {

        return view('cash_register.index');

    }

    public function show($jan_code) {

        $items = [
            [
                'title' => 'UXデザインをはじめる本',
                'jan_code' => '9784798143330',
                'price' => 2200,
                'tax_percent' => 10
            ],
            [
                'title' => 'ノンデザイナーズ・デザインブック',
                'jan_code' => '9784839928407',
                'price' => 2000,
                'tax_percent' => 10
            ],
            [
                'title' => '「納品」をなくせばうまくいく',
                'jan_code' => '9784534051943',
                'price' => 1600,
                'tax_percent' => 10
            ]
        ];
        $item = collect($items)->first(function($item) use($jan_code){

            return ($item['jan_code'] === $jan_code);

        });

        return [
            'result' => !empty($item),
            'item' => $item
        ];

    }
}
