<?php

namespace App\Http\Controllers;

use App\Models\Parking;
use chillerlan\QRCode\QRCode;
use Illuminate\Http\Request;

class ParkingController extends Controller
{
    public function qr_code(Parking $parking) {

        $url = route('parking.show', [
            'x' => $parking->location_x,
            'y' => $parking->location_y
        ]);
        $data = (new QRCode())->render($url);
        return \Image::make($data)->response();

    }

    public function show(Request $request) {

        return view('parking.show')->with([
            'x' => intval($request->x),
            'y' => intval($request->y)
        ]);

    }
}
