<?php

namespace Database\Seeders;

use App\Models\Parking;
use Illuminate\Database\Seeder;

class ParkingsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $areas = [
            [
                'name' => 'ライオンエリア',
                'location_x' => 160,
                'location_y' => 265,
            ],
            [
                'name' => '猫エリア',
                'location_x' => 480,
                'location_y' => 265,
            ],
            [
                'name' => 'うさぎエリア',
                'location_x' => 160,
                'location_y' => 410,
            ],
            [
                'name' => 'パンダエリア',
                'location_x' => 480,
                'location_y' => 410,
            ],
        ];

        foreach ($areas as $area) {

            $parking = new Parking();
            $parking->name = $area['name'];
            $parking->location_x = $area['location_x'];
            $parking->location_y = $area['location_y'];
            $parking->save();

        }
    }
}
