<?php

namespace App\Http\Controllers;

use App\Models\Post;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class PostController extends Controller
{
    public function index() {

        return view('post.index');

    }

    public function list() {

        return Post::get();

    }

    public function show(Post $post) {

        return view('post.show')->with([
            'post' => $post
        ]);

    }

    public function store(Request $request) {

        // バリデーションは省略してます

        $post = new Post();
        $post->title = $request->title;
        $post->description = $request->description;
        $result = $post->save();

        return ['result' => $result];

    }

    public function update(Request $request, Post $post) {

        // バリデーションは省略してます

        $post->title = $request->title;
        $post->description = $request->description;
        $result = $post->save();

        return ['result' => $result];

    }

    public function destroy(Post $post) {

        return [
            'result' => $post->delete()
        ];

    }

    public function upload_image(Request $request) {

        // バリデーションは省略してます

        $file = $request->file('image');
        $extension = $file->extension();
        $path = 'public/cms_images';
        $name = date('Ymd-His') .'_'. Str::random(5) .'.'. $extension;
        $request->file('image')->storeAs($path, $name);

        return [
            'result' => true,
            'image_url' => url('/storage/cms_images/'. $name)
        ];

    }
}
