<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

class ImageUploadController extends Controller
{
    public function create() {

        return view('image_upload.create');

    }

    public function store(Request $request) {

        $request->validate([
            'image' => ['required', 'image']
        ]);

        $result = false;
        $image_urls = [];

        try {

            $image = \Image::make($request->image);
            $filename = 'upload_'. date('YmdHis') .'_'. Str::random(5);
            $image_types = ['jpg', 'webp'];

            foreach ($image_types as $image_type) {

                $upload_path = 'images/upload_images/'. $image_type .'/'. $filename .'.'. $image_type;
                $image_path = public_path($upload_path);
                $image->save($image_path);

                $image_urls[$image_type] = url($upload_path);

            }

            $result = true;

        } catch (\Exception $e) {}

        return [
            'result' => $result,
            'image_urls' => $image_urls
        ];

    }
}
