<?php

namespace App\Rules;

use App\Models\User;
use Illuminate\Contracts\Validation\Rule;

class FoodOrder implements Rule
{
    private $error_message = ''; // エラーメッセージを可変にするためのメンバ変数

    public function passes($attribute, $value)
    {
        $result = false;
        $foods = $this->getFoods(); // 本来はDBなどから取得してください
        $food_ids = $foods->pluck('id');
        $food_id = intval($value);

        if($food_ids->contains($food_id)) { // 選択した商品の存在チェックをしています

            $food = $foods->where('id', $food_id)->first();
            $food_type = $food['type']; // `morning`, `regular`, `dinner` or `drink`
            $hour = now()->hour;

            if($food_type === 'morning') { // モーニング商品の場合

                if($hour >= 5 && $hour < 10) { // 5:00 〜 10:00 なら true

                    $result = true;

                } else {

                    $this->error_message = 'モーニング商品が注文できるのは「5:00 〜 10:00」だけです。';

                }

            } else if($food_type === 'regular') { // レギュラー商品の場合

                if($food_id === 5) { // フィッシュバーガーはいつでも注文OK

                    $result = true;

                } else if($hour < 5 || $hour >= 10) { // 5:00 〜 10:00 「以外」なら true

                    $result = true;

                } else {

                    $this->error_message = 'レギュラー商品は「5:00 〜 10:00」の時間帯には注文できません。';

                }

            } else if($food_type === 'dinner') { // ディナー商品の場合

                if($hour < 5 || $hour >= 17) { // 17:00 〜 5:00 なら true

                    $result = true;

                } else {

                    $this->error_message = 'ディナー商品が注文できるのは「17:00 〜 5:00」だけです。';

                }

            } else if($food_type === 'drink') { // ドリンク商品の場合

                $result = true; // いつもで注文OK

            }

        } else {

            $this->error_message = 'この商品は存在していません。';

        }

        return $result; // ② true ならバリデーション通過、false ならエラー
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return $this->error_message; // ① 好きなエラーメッセージをセットできる
    }

    private function getFoods() {

        return collect([
            ['id' => 1, 'name' => 'エッグマフィン', 'type' => 'morning'],
            ['id' => 2, 'name' => 'ソーセージマフィン', 'type' => 'morning'],
            ['id' => 3, 'name' => 'ハッシュポテト', 'type' => 'morning'],
            ['id' => 4, 'name' => 'てりやきバーガー', 'type' => 'regular'],
            ['id' => 5, 'name' => 'フィッシュバーガー', 'type' => 'regular'],
            ['id' => 6, 'name' => 'フライドポテト', 'type' => 'regular'],
            ['id' => 7, 'name' => '特大チーズバーガー', 'type' => 'dinner'],
            ['id' => 8, 'name' => '特大てりやきバーガー', 'type' => 'dinner'],
            ['id' => 9, 'name' => '特大フライドポテト', 'type' => 'dinner'],
            ['id' => 10, 'name' => 'コーラ', 'type' => 'drink'],
            ['id' => 11, 'name' => 'シェイク', 'type' => 'drink'],
            ['id' => 12, 'name' => '紅茶', 'type' => 'drink'],
        ]);

    }
}
