<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductRecommendationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_recommendations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('product_id')->comment('おすすめ商品ID');
            $table->unsignedBigInteger('original_product_id')->comment('元の商品ID');
            $table->integer('access_count')->comment('アクセス件数');
            $table->timestamps();

            $table->foreign('product_id')->references('id')->on('products');
            $table->foreign('original_product_id')->references('id')->on('products');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_recommendations');
    }
}
