<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    // リレーションシップ
    public function accesses() {

        return $this->hasMany('App\ProductAccess', 'product_id', 'id');

    }

    public function recommendations() {

        return $this->hasMany('App\ProductRecommendation', 'original_product_id', 'id')
            ->orderBy('access_count', 'desc');

    }

    // その他
    public function shouldUpdateRecommendation() { // おすすめ商品を更新すべきかどうかチェック

        return (
            is_null($this->recommendation_updated_at) ||
            now()->diffInDays($this->recommendation_updated_at) >= 3 // 最後におすすめ商品を更新してから３日以上の場合
        );

    }

    public function updateRecommendation() {

        $id = $this->id;
        $ip_addresses = $this->accesses->pluck('ip');                   // この商品にアクセスしたIP

        // IPがアクセスした他の商品を取得
        $products = \App\ProductAccess::whereIn('ip', $ip_addresses)
            ->where('product_id', '!=', $id)
            ->get();

        // おすすめ商品のデータ加工
        $access_counts = $products
            ->groupBy('product_id')    // 商品でグループ化
            ->map(function($products){ // データ件数を返す

                return $products->count();

            })
            ->filter(function($product_count){ // データ件数が３以上のものだけにする

                return ($product_count >= 3);

            })
            ->sortDesc();
        dd($access_counts->toArray());

        // おすすめデータを全削除して新規登録
        $this->recommendations()->delete();

        foreach($access_counts as $product_id => $access_count) {

            $recommendation = new \App\ProductRecommendation;
            $recommendation->original_product_id = $id;
            $recommendation->product_id = $product_id;
            $recommendation->access_count = $access_count;
            $recommendation->save();

        }

        // おすすめ商品を更新した日時を変更
        $this->recommendation_updated_at = now();
        $this->save();

    }
}
