<?php

namespace App\Http\Controllers;

use App\User;
use Illuminate\Http\Request;

class UserController extends Controller
{
    public function index()
    {
        $per_page = 3; // １ページごとの表示件数
        $users = \App\User::paginate($per_page);
        return view('user.index')->with('users', $users);
    }

    public function store(Request $request)
    {
        // [ご注意]：バリデーションは省略してます

        $user = new \App\User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->password = bcrypt($request->password);
        $result = $user->save();
        return ['result' => $result];
    }

    public function update(Request $request, User $user)
    {
        // [ご注意]：バリデーションは省略してます

        $user->name = $request->name;
        $user->email = $request->email;

        if($request->filled('password')) { // パスワード入力があるときだけ変更

            $user->password = bcrypt($request->password);

        }

        $result = $user->save();
        return ['result' => $result];
    }

    public function destroy(User $user)
    {
        $result = $user->delete();
        return ['result' => $result];
    }
}
