<?php

namespace App;

use App\Events\PostCreated;
use Illuminate\Database\Eloquent\Model;

class Post extends Model
{
    protected $dispatchesEvents = [
        'created' => PostCreated::class
    ];

    // リレーションシップ
    public function user() {

        return $this->belongsTo(\App\User::class, 'user_id', 'id');

    }
}
