<html>
<head>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="p-3">
        <h3 class="mb-4">選択したカラムのデータだけExcelでダウンロード</h3>
        <form id="form" method="post" action="/excel/download">
            @csrf
            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <!-- ダウンロード可能なカラムのチェックボックスをつくる ・・・ ① -->
                            @foreach($columns as $column)
                                <label>
                                    <input class="columns" name="columns[]" type="checkbox" value="{{ $column }}"> {{ $column }}
                                </label>
                                <br>
                            @endforeach
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary float-right">ダウンロードする</button>
                            <label>
                                <input id="all_check" type="checkbox"> 全て選択／解除
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <script>

        document.querySelector('#form') // フォーム送信されたとき実行 ・・・ ②
            .addEventListener('submit', e => {

                const columns = document.querySelectorAll('.columns:checked');

                if(columns.length === 0) {

                    e.preventDefault();
                    alert('最低でもひとつはカラムを選択してください。');

                }

            });
        document.querySelector('#all_check')    // 全て選択／解除を実行 ・・・ ③
            .addEventListener('click', e => {

                const allChecked = e.target.checked;
                const columns = document.querySelectorAll('.columns');

                for(let column of columns) {

                    column.checked = allChecked;

                }

            });

    </script>
</body>
</html>
