<?php

namespace App\Events;

use App\Item;
use App\Mail\ItemArrived;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class ItemSaved
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(Item $item)
    {
        $old_stock = intval($item->getOriginal('stock'));
        $new_stock = intval($item->stock);

        if($old_stock === 0 && $new_stock > 0) {    // 保存前はゼロだったけど、今は１以上あるとき

            foreach($item->notifications as $notification) {

                $user = $notification->user;
                \Mail::to($user)->send(new ItemArrived($item)); // メール送信

            }

        }
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('channel-name');
    }
}
