<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReceptionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('receptions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('type_id')->comment('reception_types.id');
            $table->integer('reception_number')->comment('受付番号');
            $table->string('status')->default('preparation')->comment('状態'); // preparation: 準備中, ready: 準備済み, complete: 完了
            $table->date('received_on')->comment('受付した日付');
            $table->timestamps();

            $table->foreign('type_id')->references('id')->on('reception_types');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('receptions');
    }
}
