<?php

namespace App\Http\Controllers\Ajax;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ReceptionController extends Controller
{
    public function store(Request $request) { // 新規追加

        // バリデーション
        $request->validate([
            'type_id' => 'required|integer|exists:reception_types,id'
        ]);

        // 新規待受データを追加
        $reception = new \App\Reception();
        $reception->type_id = $request->type_id;
        $result = $reception->save();
        return ['result' => $result];

    }

    public function update(Request $request) { // 更新

        // バリデーション
        $request->validate([
            'status' => 'in:ready,complete'
        ]);

        $reception = \App\Reception::find($request->id);
        $reception->status = $request->status;
        $result = $reception->save();
        return ['result' => $result];

    }
}
