<?php

namespace App;

use App\Events\CustomerDeleted;
use App\Events\CustomerSaved;
use Illuminate\Database\Eloquent\Model;

class Customer extends Model
{
    protected $dispatchesEvents = [
        'deleted' => CustomerDeleted::class
    ];

    // リレーションシップ
    public function attachments() {

        return $this->hasMany('App\Attachment', 'parent_id', 'id')
            ->where('model', self::class);  // 「App\Customer」のものだけ取得

    }
}
