const Twitter = require('twitter');
const BitlyAPI = require('node-bitlyapi');

// 定数
const TWITTER_CONSUMER_KEY = '（Twitterのコンシューマー・キー）';
const TWITTER_CONSUMER_SECRET = '（Twitterのコンシューマー・シークレット・キー）';
const TWITTER_ACCESS_TOKEN = '（Twitterのアクセストークン）';
const TWITTER_ACCESS_TOKEN_SECRET = '（Twitterのアクセストークン・シークレット）';
const BITLY_ACCESS_TOKEN = '（Bit.lyで取得したアクセストーク）';

// インスタンス
const twitter = new Twitter({
  consumer_key: TWITTER_CONSUMER_KEY,
  consumer_secret: TWITTER_CONSUMER_SECRET,
  access_token_key: TWITTER_ACCESS_TOKEN,
  access_token_secret: TWITTER_ACCESS_TOKEN_SECRET
});
const Bitly = new BitlyAPI();
const bitly = Bitly.setAccessToken(BITLY_ACCESS_TOKEN);

const url = 'https://example.com/'; // 短縮するURL
const params = { longUrl: url };
bitly.shorten(params, (error, result) => {  // 短縮URLを作成

  const results = JSON.parse(result);

  if(results.status_code === 200) { // 短縮URL作成・成功！

    const bitlyUrl = results.data.url;
    const postContent = '（ツイートの内容）'+ bitlyUrl;
    const params = { status: postContent };
    twitter.post('statuses/update', params,  (error, tweet, response) => {

      if(error) {

        // ツイート失敗

      } else {

        // ツイート成功

      }

    });

  } else {

    // 短縮URL作成・失敗...

  }

});
