#!/usr/bin/env python
# -*- coding: utf-8 -*-

import cv2
import time
from datetime import datetime
import numpy as np
import sounddevice as sd

class SoundSurveillance:

    # 定数と変数　・・・　①
    DURATION = 3            # 撮影する動画の秒数
    VOLUME_THRESHOLD = 100  # この値を超えるボリュームなら録画
    recording = False       # 録画中かどうか

    # コンストラクタ　・・・　②
    def __init__(self):
        self.listen_sound()

    # 音を監視する部分　・・・　③
    def listen_sound(self):
        duration = 60  # 音声チェックを一時的に続ける秒数
        while True:
            with sd.InputStream(callback=self.detect_sound):
                sd.sleep(duration * 1000)

    def detect_sound(self, indata, frames, time, status):
        if self.recording == False:
            volume = np.linalg.norm(indata) * 10
            if volume > self.VOLUME_THRESHOLD:
                self.recording = True
                self.start_recording()

    # 動画の保存をする部分　・・・　④
    def start_recording(self):

        self.recording = True
        save_path = './movies/'+ datetime.now().strftime('%Y%m%d%H%M%S') +'.avi'
        print('Recording...('+ save_path +')')

        cap = cv2.VideoCapture(0)

        # ウェブカメラのサイズを取得する
        f_width = int(cap.get(cv2.CAP_PROP_FRAME_WIDTH))
        f_height = int(cap.get(cv2.CAP_PROP_FRAME_HEIGHT))

        fourcc = cv2.VideoWriter_fourcc(*'XVID')
        video_writer = cv2.VideoWriter(save_path, fourcc, 25, (f_width, f_height))

        started_time = time.time()

        # ウェブカメラの映像を保存
        while(cap.isOpened()):
            ret, frame = cap.read()
            diff_time = time.time() - started_time
            if ret == False or diff_time >= self.DURATION:
                break
            else:
                video_writer.write(frame)

        cap.release()
        video_writer.release()
        cv2.destroyAllWindows()
        self.recording = False
        print('Recording finished.')

ss = SoundSurveillance()
