<?php

namespace App\Http\Controllers;

use GifCreator\GifCreator;
use Illuminate\Http\Request;

class AnimatedGifController extends Controller
{
    public function create() {

        return view('animated_gif.create');

    }

    public function store(Request $request) {

        $result = false;
        $gif_url = '';

        if($request->hasFile('images')) {

            $frames = [];       // 画像のコマ
            $durations = [];    // 画像が変化する間隔（ミリ秒）
            $loop = 0;          // 何回ループするか。0は無限

            foreach($request->images as $image) {

                if($image->isValid()) {

                    $frames[] = $image->path();
                    $durations[] = 20;

                }

            }

            $gc = new GifCreator();
            $gc->create($frames, $durations, $loop);
            $gif_data = $gc->getGif();

            $uri = 'images/gif/'. date('U') .'.gif';
            $save_path = public_path($uri);
            file_put_contents($save_path, $gif_data);

            $result = true;
            $gif_url = url($uri);

        }

        return [
            'result' => $result,
            'gif_url' => $gif_url
        ];

    }
}
