<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class PerspectiveTransformController extends Controller
{
    public function upload() {

        return view('perspective_transform');

    }

    public function download() {

        return response()->download($this->getImageFilePath());

    }

    public function transform(Request $request) {

        $imagick = new \Imagick();
        $imagick->readImage($request->image);
        $image_width = $imagick->getImageWidth();
        $image_height = $imagick->getImageHeight();

        // 割合から実際のX,Y座標を取得する
        $from_points = [];

        foreach($request->selected_points as $point) {

            $from_points[] = [
                'x' => intval($image_width * $point['x']),
                'y' => intval($image_height * $point['y']),
            ];

        }

        // 修正後の画像サイズを取得
//        $selected_width = sqrt(
//            pow($from_points[1]['x'] - $from_points[0]['x'], 2) +
//            pow($from_points[1]['y'] - $from_points[0]['y'], 2)
//        );
//        $selected_height = sqrt(
//            pow($from_points[3]['x'] - $from_points[0]['x'], 2) +
//            pow($from_points[3]['y'] - $from_points[0]['y'], 2)
//        );
//
//        if($selected_width > $selected_height) {  // 横長の場合
//
//            $selected_height_ratio = $selected_height / $selected_width;
//            $image_height = intval($image_width * $selected_height_ratio);
//
//        } else {    // 縦長の場合
//
//            $selected_width_ratio = $selected_width / $selected_height;
//            $image_width = intval($image_height * $selected_width_ratio);
//
//        }

        // ずれを修正するための座標を作成（移動元 → 移動後）
        $distortion_points = [

            /*  左上  */
            $from_points[0]['x'], $from_points[0]['y'],   // 移動元(x,y)
            0, 0,   // 移動先(x,y)

            /*  右上  */
            $from_points[1]['x'], $from_points[1]['y'],   // 移動元(x,y)
            $image_width, 0,    // 移動先(x,y)

            /*  右下  */
            $from_points[2]['x'], $from_points[2]['y'],   // 移動元(x,y)
            $image_width, $image_height,  // 移動先(x,y)

            /*  左下  */
            $from_points[3]['x'], $from_points[3]['y'],   // 移動元(x,y)
            0, $image_height    // 移動先(x,y)

        ];

        $result = false;

        try {

            // 画像の修正
            $imagick->distortImage(\Imagick::DISTORTION_PERSPECTIVE, $distortion_points, false);

            // 対象部分だけ切り出し
//            $imagick->cropImage($image_width, $image_height, 0, 0);

            // 画像の保存
            $imagick->writeImage($this->getImageFilePath());

            $result = true;

        } catch (\Exception $e) {}

        return ['result' => $result];

    }

    private function getImageFilePath() {

        return storage_path('app/perspective_transform.png');

    }
}
