<?php

    $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    
    // セルの入力
    $sheet->setCellValue('A1', 'テスト文字列');
    $sheet->setCellValue('B1', 100);
    $sheet->setCellValue('C1', true);
    $sheet->setCellValue('D1', null);   // 空白
    
    // 書式を指定して入力
    $sheet->setCellValueExplicit(
        'E1',
        '012345',
        \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
    );
    
    // 郵便番号として入力
    $sheet->getStyle('F1')
        ->getNumberFormat()
        ->setFormatCode('000-0000');
    $sheet->setCellValue('F1', 1310045);
    
    // 日時として入力
    $sheet->getStyle('G1')
        ->getNumberFormat()
        ->setFormatCode('yyyy-mm-dd h:mm:ss');
    $datetime = \PhpOffice\PhpSpreadsheet\Shared\Date::PHPToExcel('2019/01/01 01:02:03');
    $sheet->setCellValue('G1', $datetime);
    
    // 一気に入力
    $data = [
        ['テスト1-1', 'テスト1-2', 'テスト1-3'],
        ['テスト2-1', 'テスト2-2', 'テスト2-3'],
        ['テスト3-1', 'テスト3-2', 'テスト3-3']
    ];
    $exception_value = 'テスト2-2';   // この値のものは反映されない（全て反映するにはnullを指定）
    $sheet->fromArray($data, $exception_value, 'A3');
    
    // 式の入力
    $sheet->setCellValue('A7', '=CONCATENATE(A1, " - ", B1)');
    
    // セルの結合
    $sheet->mergeCells('A9:C9');
    $sheet->setCellValue('A9', '結合されたセル');
    
    // 改ページ
    $sheet->setBreak('A11', \PhpOffice\PhpSpreadsheet\Worksheet\Worksheet::BREAK_ROW);
    
    // ドロップダウン（直接指定）
    $sheet->setCellValue('A13', '選択肢1');
    $validation = new DataValidation();
    $validation->setFormula1('"選択肢1,選択肢2,選択肢3"');
    $validation->setType('list');
    $validation->setAllowBlank(true);
    $validation->setShowDropDown(true);
    $sheet->setDataValidation('A13', $validation);
    
    // ドロップダウン（参照）
    $sheet->setCellValue('A15', '選択肢A');    //　ここが選択ボックス
    $sheet->setCellValue('B16', '選択肢A');    // 参照する選択肢
    $sheet->setCellValue('B17', '選択肢B');    // 参照する選択肢
    $sheet->setCellValue('B18', '選択肢C');    // 参照する選択肢
    
    $validation = new DataValidation();
    $validation->setFormula1('$B$15:$B$18');
    $validation->setType('list');
    $validation->setAllowBlank(true);
    $validation->setShowDropDown(true);
    $sheet->setDataValidation('A15', $validation);
    
    // オートフィルタ
    $sheet->setCellValue('A20', 'オートフィルタ');
    $sheet->setCellValue('A21', '選択肢（１）');
    $sheet->setCellValue('A22', '選択肢（２）');
    $sheet->setCellValue('A23', '選択肢（３）');
    $sheet->setAutoFilter('A20:A20');
    
    // 枠線の表示、非表示
    //        $sheet->setShowGridlines(false);
    
    // 文字の色を指定する
    $sheet->setCellValue('A25', '文字の色・赤');
    $sheet->getStyle('A25')
        ->getFont()
        ->getColor()
        ->setARGB('FFFF0000');
    
    // 背景色を指定する
    $sheet->setCellValue('A27', '背景色・赤');
    $sheet->getStyle('A27')
        ->getFill()
        ->setFillType('solid')
        ->getStartColor()
        ->setARGB('FFFF0000');
    
    // 枠線
    $sheet->setCellValue('A29', '枠線');
    
    $borders = $sheet->getStyle('A29')->getBorders();
    $borders
        ->getTop()
        ->setBorderStyle('thick');  // 太線
    $borders
        ->getRight()
        ->setBorderStyle('thin');   // 細線
    $borders
        ->getBottom()
        ->setBorderStyle('thick');  // 太線
    $borders
        ->getLeft()
        ->setBorderStyle('thin');   // 細線
    
    // 右寄せ、左寄せ、中央寄せ
    $sheet->setCellValue('A31', '右寄せ');
    
    $sheet->getStyle('A31')
        ->getAlignment()
        ->setHorizontal('right');
    $sheet->setCellValue('B31', '左寄せ');
    $sheet->getStyle('B31')
        ->getAlignment()
        ->setHorizontal('left');
    $sheet->setCellValue('C31', '中央寄せ');
    $sheet->getStyle('C31')
        ->getAlignment()
        ->setHorizontal('center');
    
    // 太字
    $sheet->setCellValue('A33', '太字');
    
    $sheet->getStyle('A33')
        ->getFont()
        ->setBold(true);
    
    // ななめ文字
    $sheet->setCellValue('A35', 'ななめ文字');
    
    $sheet->getStyle('A35')
        ->getFont()
        ->setItalic(true);
    
    // サイズ
    $sheet->setCellValue('A37', '文字サイズを指定');
    
    $sheet->getStyle('A37')
        ->getFont()
        ->setSize(8);
    
    // 下線
    $sheet->setCellValue('A39', '下線あり');
    
    $sheet->getStyle('A39')
        ->getFont()
        ->setUnderline(true);
    
    $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
    $writer->save('/PATH/TO/YOUR/PROJECT/test.xlsx');
    
    // 値の取得
    echo $sheet->getCell('A1')->getValue();
    echo $sheet->getCell('A7')->getCalculatedValue();   // 式を計算して取得
    echo $sheet->getCell('G1')->getFormattedValue();   // 表示フォーマットで取得
    $data = $sheet->rangeToArray('A3:C5');  // 配列で取得
    print_r($data);
    
    // Excelファイルの読み込み
    $reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader('Xlsx');
    $spreadsheet = $reader->load('/PATH/TO/YOUR/PROJECT/test2.xlsx');
    $sheet = $spreadsheet->getActiveSheet();
    
    $data = [];
    
    foreach ($sheet->getRowIterator() as $i => $row) {
    
        $row_data = [];
        $cellIterator = $row->getCellIterator();
        $cellIterator->setIterateOnlyExistingCells(FALSE);
    
        foreach ($cellIterator as $j => $cell) {
    
            $cell_id = $i .'-'. $j;
            $row_data[$cell_id] = $cell->getValue();
    
        }
    
        $data[$i] = $row_data;
    
    }
    
    print_r($data);
