<html>
<body>
    <div id="app">
        <button type="button" v-if="params.token && !isSubmitting" @click="onSubmit">送信</button>
    </div>
    <script src="https://www.google.com/recaptcha/api.js?render={{ env('RECAPTCHA_SITE_KEY') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.18.0/axios.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/vue@2.6.10/dist/vue.min.js"></script>
    <script>

        new Vue({
            el: '#app',
            data: {
                params: {
                    token: ''
                },
                isSubmitting: false
            },
            methods: {
                onSubmit() {

                    this.isSubmitting = true;

                    axios.post('/recaptcha_ajax', this.params)
                        .then((response) => {

                            // 送信成功

                        })
                        .catch((error) => {

                            // ここでエラー処理

                        })
                        .then(() => {

                            this.isSubmitting = false;
                            this.setRecaptchaToken();

                        })

                },
                setRecaptchaToken() {

                    grecaptcha.ready(() => {
                        grecaptcha.execute('{{ env('RECAPTCHA_SITE_KEY') }}', {action: 'homepage'})
                            .then((token) => {

                                this.params.token = token

                            });
                    });

                }
            },
            mounted() {

                this.setRecaptchaToken();

            }
        })

    </script>
</body>
</html>