<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function pdftoimage() {

        $pdf_path = storage_path('app/pdf/wagahaihanekodearu.pdf');
        $pdf = new \Spatie\PdfToImage\Pdf($pdf_path);

        /* 各種パラメータ設定 */
        $pdf->setPage(1);
        $pdf->setOutputFormat('jpg');
        $pdf->setCompressionQuality(100);
        $pdf->setResolution(144);
        $pdf->setLayerMethod(\imagick::LAYERMETHOD_COALESCE);

        $image_path = storage_path('app/images/wagahaihanekodearu.jpg');
        $pdf->saveImage($image_path);

        echo $pdf->getNumberOfPages(); // ページ数を取得

        if(!$pdf->isValidOutputFormat('gif')) { // 画像形式のチェック

            echo 'この形式はサポートしていません。';

        }

        $imagick = $pdf->getImageData();

    }

    public function pdftotext() {

        $pdf_path = storage_path('app/pdf/wagahaihanekodearu.pdf');
        $text = \Spatie\PdfToText\Pdf::getText($pdf_path, '/usr/bin/pdftotext', [
            'x 0',
            'y 30',
            'W 1000',
            'H 500'
            ]);
        $text_path = storage_path('app/text/wagahaihanekodearu.txt');
        file_put_contents($text_path, $text);

        // echo '<pre>'.$text .'</pre>';

    }
}
