<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];


    // Accessor
    public function getUserCodeAttribute() {

        return str_pad($this->id, 4, '0', STR_PAD_LEFT);

    }

    public function getPrefectureNameAttribute() {

        $prefs = [
            '1' => '北海道',
            '2' => '青森県',
            '3' => '岩手県',
            '4' => '宮城県',
            '5' => '秋田県',
            '6' => '山形県',
            '7' => '福島県',
            '8' => '茨城県',
            '9' => '栃木県',
            '10' => '群馬県',
            '11' => '埼玉県',
            '12' => '千葉県',
            '13' => '東京都',
            '14' => '神奈川県',
            '15' => '新潟県',
            '16' => '富山県',
            '17' => '石川県',
            '18' => '福井県',
            '19' => '山梨県',
            '20' => '長野県',
            '21' => '岐阜県',
            '22' => '静岡県',
            '23' => '愛知県',
            '24' => '三重県',
            '25' => '滋賀県',
            '26' => '京都府',
            '27' => '大阪府',
            '28' => '兵庫県',
            '29' => '奈良県',
            '30' => '和歌山県',
            '31' => '鳥取県',
            '32' => '島根県',
            '33' => '岡山県',
            '34' => '広島県',
            '35' => '山口県',
            '36' => '徳島県',
            '37' => '香川県',
            '38' => '愛媛県',
            '39' => '高知県',
            '40' => '福岡県',
            '41' => '佐賀県',
            '42' => '長崎県',
            '43' => '熊本県',
            '44' => '大分県',
            '45' => '宮崎県',
            '46' => '鹿児島県',
            '47' => '沖縄県'
        ];
        return array_get($prefs, $this->prefecture_id);

    }

// テストデータと重複するためコメントアウト
//    public function getPrefectureIdAttribute() {
//
//        $prefs = [
//            '1' => '北海道',
//            '2' => '青森県',
//            '3' => '岩手県',
//            '4' => '宮城県',
//            '5' => '秋田県',
//            '6' => '山形県',
//            '7' => '福島県',
//            '8' => '茨城県',
//            '9' => '栃木県',
//            '10' => '群馬県',
//            '11' => '埼玉県',
//            '12' => '千葉県',
//            '13' => '東京都',
//            '14' => '神奈川県',
//            '15' => '新潟県',
//            '16' => '富山県',
//            '17' => '石川県',
//            '18' => '福井県',
//            '19' => '山梨県',
//            '20' => '長野県',
//            '21' => '岐阜県',
//            '22' => '静岡県',
//            '23' => '愛知県',
//            '24' => '三重県',
//            '25' => '滋賀県',
//            '26' => '京都府',
//            '27' => '大阪府',
//            '28' => '兵庫県',
//            '29' => '奈良県',
//            '30' => '和歌山県',
//            '31' => '鳥取県',
//            '32' => '島根県',
//            '33' => '岡山県',
//            '34' => '広島県',
//            '35' => '山口県',
//            '36' => '徳島県',
//            '37' => '香川県',
//            '38' => '愛媛県',
//            '39' => '高知県',
//            '40' => '福岡県',
//            '41' => '佐賀県',
//            '42' => '長崎県',
//            '43' => '熊本県',
//            '44' => '大分県',
//            '45' => '宮崎県',
//            '46' => '鹿児島県',
//            '47' => '沖縄県'
//        ];
//        return array_search($this->prefecture, $prefs);
//
//    }

    public function getFullNameAttribute() {

        return $this->first_name .' '. $this->last_name;

    }

    public function getUnitAgeAttribute() {

        return $this->age .'歳';

    }

    public function getBirthWarekiYearAttribute() {

        $year = $this->birth_year;
        $wareki_year = 0;

        if ($year >= 2019) {

            $era_name = '（新元号）';
            $wareki_year = $year - 2018;

        } else if ($year >= 1989) {

            $era_name = '平成';
            $wareki_year = $year - 1988;

        } else if ($year >= 1926) {

            $era_name = '昭和';
            $wareki_year = $year - 1925;

        } else if ($year >= 1912) {

            $era_name = '大正';
            $wareki_year = $year - 1911;

        } else {

            $era_name = '明治';
            $wareki_year = $year - 1867;

        }

        $wareki_year = ($wareki_year == 1) ? '元' : $wareki_year;
        return $era_name . $wareki_year .'年';

    }

    public function getCommaAmountAttribute() {

        return number_format($this->amount);

    }

    public function getYenAmountAttribute() {

        return number_format($this->amount) .'円';

    }

    public function getHasPermissionAttribute() {

        return ($this->role == 'admin');

    }

    public function getFullPostalCodeAttribute() {

        return $this->first_postal_code .'-'. $this->last_postal_code;

    }

    public function getGoogleMapUrlAttribute() {

        return 'https://www.google.co.jp/maps/place/'. urlencode($this->address);

    }

    public function getPositionNameAttribute() {

        $positions = [
            1 => '会長',
            2 => '社長',
            3 => '副社長',
            4 => '専務',
            5 => '常務',
            6 => '支社長',
            7 => '本部長',
            8 => '部長',
            9 => '次長',
            10 => '室長',
            11 => '課長',
            12 => '係長',
            13 => '主任'
        ];
        return array_get($positions, $this->position_id);

    }

    public function getSectionNameAttribute() {

        $sections = [
            1 => '総務部',
            2 => '人事部',
            3 => '経理部',
            4 => '営業部',
            5 => '開発部',
            6 => '事業部',
            7 => '製造部'
        ];
        return array_get($sections, $this->section_id);

    }

    public function getUnitBloodTypeAttribute() {

        return $this->blood_type .'型';

    }

    public function getUnitHeightAttribute() {

        return $this->height .'cm';

    }

    public function getUnitWeightAttribute() {

        return $this->weight .'kg';

    }

    public function getAmountTaxAttribute() {

        $tax_percentage = 8;
        return floor($this->amount * $tax_percentage * 0.01);

    }

    public function getAmountIncludingTaxAttribute() {

        $tax_percentage = 8;
        $amount = $this->amount;
        return $amount + floor($amount * $tax_percentage * 0.01);

    }


    // テストデータ（ここ以降は削除してください）
    public function getAmountAttribute() {

        return '10000';

    }

    public function getBloodTypeAttribute() {

        return 'A';

    }

    public function getHeightAttribute() {

        return '168';

    }

    public function getWeightAttribute() {

        return '55';

    }

    public function getPrefectureIdAttribute() {

        return '13';

    }

    public function getFirstNameAttribute() {

        return '山田';

    }

    public function getLastNameAttribute() {

        return '太郎';

    }

    public function getAgeAttribute() {

        return 20;

    }

    public function getFirstPostalCodeAttribute() {

        return '131';

    }

    public function getLastPostalCodeAttribute() {

        return '0045';

    }

    public function getAddressAttribute() {

        return '東京都墨田区押上１丁目１−２';

    }

    public function getBirthYearAttribute() {

        return 1989;

    }

    public function getPositionIdAttribute() {

        return 1;

    }

    public function getSectionIdAttribute() {

        return 5;

    }

    public function getRoleAttribute() {

        return 'admin';

    }
}
