<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRedeliveriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('redeliveries', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->comment('UUID');
            $table->date('redelivery_date')->nullable()->comment('再配達希望日');
            $table->integer('redelivery_time_id')->nullable()->comment('再配達希望時間帯 ID');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('redeliveries');
    }
}
