<?php

namespace App\Http\Controllers;

use App\Models\Redelivery;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class RedeliveryController extends Controller
{
    public function edit(Redelivery $redelivery) {

        $this->checkValid($redelivery);

        return view('redelivery.edit')->with([
            'redelivery' => $redelivery
        ]);

    }

    public function update(Request $request, Redelivery $redelivery) {

        $time_ids = config('redelivery.times')->pluck('id');
        $request->validate([
            'date' => [
                'required',
                'date',
                'after_or_equal:today'
            ],
            'time_id' => [
                'required',
                Rule::In($time_ids)
            ]
        ]);
        $this->checkValid($redelivery);

        $redelivery->redelivery_date = $request->date;
        $redelivery->redelivery_time_id = $request->time_id;
        $result = $redelivery->save();

        // 保存に成功したらここでメールやLINE通知などをするといいでしょう

        return [
            'result' => $result
        ];

    }

    private function checkValid($redelivery) {

        if(is_null($redelivery)) {

            abort(404);

        } else if($redelivery->redelivery_requested) {

            abort(400, 'すでに再配達依頼は登録されています');

        }

    }
}
