<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Redelivery extends Model
{
    use HasFactory;

    // Accessor
    public function getUrlAttribute() { // 再配達依頼ページのURL

        return route('redelivery.edit', $this->uuid);

    }

    public function getRedeliveryRequestedAttribute() { // すでに再配達依頼しているかどうか

        return (
            !is_null($this->redelivery_date) &&
            !is_null($this->redelivery_time_id)
        );

    }
}
