<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSplitTestingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('split_testings', function (Blueprint $table) {
            $table->id();
            $table->string('name')->comment('テスト名');
            $table->string('view_index')->comment('ビューのインデックス番号'); // つまり、ABどちらの表示か
            $table->uuid('uuid')->comment('UUID'); // 個人の特定用
            $table->boolean('accessed')->default(false)->comment('アクセスされたかどうか');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('split_testings');
    }
}
