<?php

namespace App\View\Components;

use Illuminate\Support\Arr;
use Illuminate\Support\Str;
use Illuminate\View\Component;
use App\Models\SplitTesting as SplitTestingModel;

class SplitTesting extends Component
{
    private $name, $views;

    public function __construct($name, $views)
    {
        $this->name = $name;
        $this->views = $views;
    }

    public function render()
    {
        $view = $this->getView();
        return view($view);
    }

    private function getKey() {

        return 'split_testing_'. $this->name;

    }

    private function getView() {

        $existing_index = $this->getExistingViewIndex();

        if($existing_index > -1) { // すでに表示済みの場合（前回と同じものを表示する）

            $cookie_index = $existing_index;

        } else {

            $cookie_index = $this->getRandomViewIndex();

        }

        return $this->views[$cookie_index];

    }

    private function getExistingViewIndex() {

        foreach($this->views as $index => $view) {

            $key = $this->getKey();

            if(\Cookie::has($key)) {

                $cookie_data = json_decode(
                    \Cookie::get($key)
                );
                return $cookie_data->index;

            }

        }

        return -1;

    }

    private function getRandomViewIndex() {

        // キャッシュ保存
        $key = $this->getKey();
        $view_index = \Cache::get($key, -1); // 初期値は -1（つまり最初は次の行でゼロになる）
        $view_index++;

        if(!Arr::has($this->views, $view_index)) {

            $view_index = 0;

        }

        \Cache::put($key, $view_index);

        // Cookie 保存
        $uuid = Str::uuid();
        $cookie_values = [
            'index' => $view_index,
            'uuid' => $uuid
        ];

        \Cookie::queue($key, json_encode($cookie_values) , 2628000); // 5年間インデックスを保存

        // DBに画像が表示されたデータを保存
        $split_testing = new SplitTestingModel();
        $split_testing->name = $this->name;
        $split_testing->view_index = $view_index;
        $split_testing->uuid = $uuid;
        $split_testing->save();

        return $view_index;

    }
}
