<html>
<head>
    <link href="https://unpkg.com/tailwindcss@^2/dist/tailwind.min.css" rel="stylesheet">
</head>
<body>
<div id="app" class="p-3">
    <div class="grid grid-cols-1 text-3xl p-2">
        <h1 class="mb-4 text-green-500 font-bold">リアルタイム・オンライン通知</h1>
    </div>
    <div class="grid grid-cols-6">
        <div>
            <div class="px-2 py-1">
                <small class="text-gray-500">ユーザー</small>
            </div>
            <div class="col-span-1 bg-blue-100 px-3 py-2 text-blue-700">
                <div v-for="u in users">
                    <div class="grid grid-cols-2 mb-2">
                        <div v-text="u.name"></div>
                        <div v-if="u.is_online" class="text-green-700 text-xs text-right font-bold">オンライン</div>
                        <div v-else class="text-gray-400 text-xs text-right">オフライン</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="/js/app.js"></script>
<script src="https://unpkg.com/vue@3.0.2/dist/vue.global.prod.js"></script>
<script>

    Vue.createApp({
        data() {
            return {
                users: []
            }
        },
        methods: {
            getUsers() { // ユーザー情報をAjaxで取得する

                axios.get('/users')
                    .then(response => {

                        this.users = response.data;

                    });

            }
        },
        mounted() {

            this.getUsers();

            Echo.channel('online_users')
                .listen('UserAccessed', e => {

                    this.getUsers(); // リアルタイム通知があれば自動更新

                });

        }
    }).mount('#app');

</script>
</body>
</html>
