<html>
<head>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
</head>
<body>
<div id="app" class="p-3">
    <!-- ⑥ 取得したデータの表示 -->
    <div v-for="user in users.data" v-if="users">
        <div v-text="user.name"></div>
    </div>
    <br>
    <!-- ⑦ 独自コンポーネントを実行する -->
    <v-pagination :data="users" :link-max="7" @page-move="onMovePage"></v-pagination>
</div>
<script src="https://unpkg.com/vue@3.0.2/dist/vue.global.prod.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.19.2/axios.min.js"></script>
<script>

    // ① ページリンク・コンポーネントを定義する
    const paginationComponent = {
        // ② プロパティを定義
        props: {
            data: {
                type: Object,
                default: {}
            },
            linkMax: {
                type: Number,
                default: 5
            }
        },
        methods: {
            moveTo(page) {

                document.activeElement.blur(); // クリックされたときのフォーカスを外す
                this.$emit('page-move', parseInt(page)); // ③ 独自のイベントを送出

            },
            movePrev() {

                const page = Math.max(this.currentPage - 1, 1); // ⑤-1 1より少ないときは1になる
                this.moveTo(page);

            },
            moveNext() {

                const page = Math.min(this.currentPage + 1, this.lastPage); // ⑤-2 最大ページより大きいときは最大ページになる
                this.moveTo(page);

            },
            classes(page) {

                return (parseInt(page) === this.currentPage) ? 'active' : '';

            }
        },
        computed: {
            hasData() {

                return (Object.keys(this.data).length > 0);

            },
            currentPage() {

                return parseInt(this.data.current_page);

            },
            lastPage() {

                return parseInt(this.data.last_page);

            },
            pages() { // ④ 表示すべきページ番号を計算

                let pages = [];
                const lastPage = this.lastPage;

                for(let i = 1 ; i <= lastPage ; i++) {

                    pages.push(i);

                }

                if(pages.length > this.linkMax) {

                    const pageIndex = this.currentPage - 1;
                    const leftMaxPage = Math.floor(this.linkMax * 0.5);
                    const rightMaxPage = this.linkMax - leftMaxPage;
                    const leftDiff = pageIndex - leftMaxPage;
                    const rightDiff = pageIndex + rightMaxPage - pages.length;
                    let start = (leftDiff >= 0)
                        ? leftDiff - Math.max(0, rightDiff)
                        : 0;
                    const end = start + this.linkMax;
                    pages = pages.slice(start, end);

                }

                return pages;

            }
        },
        template: `
            <div v-if="hasData">
                <ul class="pagination">
                    <li class="page-item">
                        <a class="page-link" href="#" aria-label="Previous" @click.prevent="movePrev()">
                            <span aria-hidden="true">&laquo;</span>
                        </a>
                    </li>
                    <li class="page-item" v-for="p in pages" :class="classes(p)">
                        <a class="page-link" href="#" v-text="p" @click.prevent="moveTo(p)"></a>
                    </li>
                    <li class="page-item">
                        <a class="page-link" href="#" aria-label="Next" @click.prevent="moveNext()">
                            <span aria-hidden="true">&raquo;</span>
                        </a>
                    </li>
                </ul>
            </div>
        `
    };

    Vue.createApp({
        data() {
            return {
                users: {}
            }
        },
        methods: {
            onMovePage(page = 1) { // ⑧ Ajaxでデータを取得する

                const url = '/users?page='+ page;
                axios.get(url)
                    .then(response => {

                        this.users = response.data;

                    });

            }
        },
        mounted() {

            // ⑨ ページ表示後すぐデータを取得
            this.onMovePage();

        }
    })
    .component('v-pagination', paginationComponent) // Vueにコンポーネントをセットする
    .mount('#app');

</script>
</body>
</html>
