<html>
<head>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
</head>
<body>
<div id="app">
    <!-- 駐車したエリアのデータを保存する場合 -->
    <div v-if="mode=='save'">
        <div class="p-3 text-center" v-if="locationSaved">
            駐車位置を保存しました。
        </div>
    </div>
    <!-- 駐車したエリアのデータを表示する場合 -->
    <div id="canvas-box" v-else-if="mode=='show'">
        <canvas id="canvas"></canvas>
    </div>
</div>
<script src="https://unpkg.com/vue@3.0.2/dist/vue.global.prod.js"></script>
<script>

    Vue.createApp({
        data() {
            return {
                location: {
                    x: {{ $x }},
                    y: {{ $y }},
                },
                locationSaved: false,
                canvas: null,
                context: null,
                mapImage: null
            }
        },
        methods: {
            save() {

                try {

                    const parkingData = JSON.stringify(this.location);
                    localStorage.setItem('parking_location', parkingData);
                    this.locationSaved = true;

                } catch (e) {

                    console.log(e);
                    alert('残念ながらブラウザが対応していません。');

                }

            },
            show() {

                this.context.drawImage(this.mapImage, 0, 0, this.canvas.width, this.canvas.height);

                const parkingData = JSON.parse(
                    localStorage.getItem('parking_location')
                );
                const parkingX = parkingData.x;
                const parkingY = parkingData.y;
                const radius = this.canvas.width * 0.085;
                const x = this.canvas.width * parkingX / this.mapImage.width;
                const y = this.canvas.height * parkingY / this.mapImage.height;
                this.context.arc(x, y, radius, 0, 2 * Math.PI);
                this.context.strokeStyle = '#ffff99';
                this.context.lineWidth = 10;
                this.context.stroke();

            }
        },
        computed: {
            mode() {

                return (this.location.x > 0 && this.location.y > 0)
                    ? 'save'
                    : 'show';

            }
        },
        mounted() {

            if(this.mode === 'save') {

                this.save();

            } else if(this.mode === 'show') {

                this.mapImage = new Image;
                this.mapImage.onload = () => {

                    const canvasWidth = document.querySelector('#canvas-box').clientWidth;
                    const canvasHeight = canvasWidth * this.mapImage.height / this.mapImage.width;
                    this.canvas = document.querySelector('#canvas');
                    this.canvas.width = canvasWidth;
                    this.canvas.height = canvasHeight;
                    this.context = this.canvas.getContext('2d');
                    this.show();

                };
                this.mapImage.src = '/images/parking_map.png';

            }

        }
    }).mount('#app');

</script>
</body>
</html>
