<?php

namespace Database\Seeders;

use App\Models\Athlete;
use App\Models\Comedian;
use App\Models\Musician;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class MultiAuthTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // 芸人
        $init_comedians = [
            [
                'name' => '明石家さんま',
                'email' => 'sanma@example.com',
                'password' => 'secret',
                'tv_programs' => 'ホンマでっかTV、お笑い向上委員会',
                'master' => '笑福亭松之助'
            ],

            // ここに追加できます
        ];

        foreach($init_comedians as $init_comedian) {

            $comedian = new Comedian();
            $comedian->name = $init_comedian['name'];
            $comedian->email = $init_comedian['email'];
            $comedian->password = Hash::make($init_comedian['password']);
            $comedian->tv_programs = $init_comedian['tv_programs'];
            $comedian->master = $init_comedian['master'];
            $comedian->save();

        }

        // ミュージシャン
        $init_musicians = [
            [
                'name' => 'Yoshiki',
                'email' => 'yoshiki@example.com',
                'password' => 'secret',
                'instruments' => 'ピアノ、ドラム',
                'genre' => 'ロック、クラシック'
            ],

            // ここに追加できます
        ];

        foreach($init_musicians as $init_musician) {

            $musician = new Musician();
            $musician->name = $init_musician['name'];
            $musician->email = $init_musician['email'];
            $musician->password = Hash::make($init_musician['password']);
            $musician->instruments = $init_musician['instruments'];
            $musician->genre = $init_musician['genre'];
            $musician->save();

        }

        // アスリート
        $init_athletes = [
            [
                'name' => 'ヒクソン・グレイシー',
                'email' => 'rickson@example.com',
                'password' => 'secret',
                'sports_type' => '柔術',
                'is_active' => false
            ],

            // ここに追加できます
        ];

        foreach($init_athletes as $init_athlete) {

            $athlete = new Athlete();
            $athlete->name = $init_athlete['name'];
            $athlete->email = $init_athlete['email'];
            $athlete->password = Hash::make($init_athlete['password']);
            $athlete->sports_type = $init_athlete['sports_type'];
            $athlete->is_active = $init_athlete['is_active'];
            $athlete->save();

        }

    }
}
