<?php

namespace App\Observers;

use Illuminate\Database\Eloquent\Model;

class HistoryObserver
{
    public function created(Model $model) {

        $this->saveHistory($model, 'created');

    }

    public function updated(Model $model) {

        $this->saveHistory($model, 'updated');

    }

    public function deleted(Model $model) {

        $this->saveHistory($model, 'deleted');

    }

    private function saveHistory($model, $type) {

        $model_class = get_class($model);
        $primary_key = $model->getKeyName();
        $model_id = $model->{$primary_key};
        $version = \App\History::getNextVersionNumber($model_class, $model_id);
        $hidden = $model->getHidden();
        $data = $model->makeVisible($hidden);

        $history = new \App\History;
        $history->model = $model_class;
        $history->model_id = $model_id;
        $history->version = $version;
        $history->type = $type;
        $history->data = $data;
        $history->save();

    }
}
