<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class History extends Model
{
    protected $casts = [
        'data' => 'json'
    ];

    // Others
    public function revert() {

        $self = $this; // use() には $this を使えないので別の変数へ格納

        Model::withoutEvents(function() use($self){ // この中はイベントが実行されない

            // データを元に戻す
            $model = (new $self->model())->firstOrNew(['id' => $self->model_id]);

            foreach($self->data as $key => $value) {

                $model->{$key} = (is_array($value)) ? json_encode($value) : $value;

            }

            $model->save();

            // 新しい履歴を追加
            $history = $self->replicate(); // 履歴データを複製
            $history->version = $self->getNextVersionNumber($history->model, $history->model_id);
            $history->type = 'reverted';
            $history->save();

        });

    }

    public static function getNextVersionNumber($model, $id) {

        return self::where('model', $model)
                ->where('model_id', $id)
                ->max('version') + 1;

    }
}
