<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use \App\Product;

// 省略

Route::get('product/{product}', function(Request $request, Product $product){

    if($product->shouldUpdateRecommendation()) {

        $product->updateRecommendation();

    }

    $product->load('recommendations.product'); // リレーションシップを読み込み

    // 商品へのアクセスデータを追加
    \App\ProductAccess::FirstOrNew([
        'product_id' => $product->id,
        'ip' => $request->ip()
    ])->save();

    return view('product')->with([
        'product' => $product
    ]);

});
