<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    // Relationship
    public function user_introductions() {

        return $this->hasManyThrough(
            'App\User',
            'App\UserIntroduction',
            'introduced_user_id',
            'id',
            'id',
            'registered_user_id'
        )->orderBy('id', 'asc');

    }

    // Accessor
    public function getIntroductionUrlAttribute() {

        $user_id = $this->id;

        return route('register', [
            'introduced_user_id' => $user_id
        ]);

    }
}
