<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserIntroductionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_introductions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('introduced_user_id')->comment('紹介をしたユーザーのID');
            $table->unsignedBigInteger('registered_user_id')->comment('紹介経由で登録したユーザーのID');
            $table->timestamps();

            $table->foreign('introduced_user_id')->references('id')->on('users');
            $table->foreign('registered_user_id')->references('id')->on('users');
            $table->unique(['introduced_user_id', 'registered_user_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_introductions');
    }
}
