<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class ExcelController extends Controller
{
    public function form() {

        $columns = (new \App\User)->getTableColumns();
        return view('excel.form')->with('columns', $columns);

    }

    public function download(Request $request) {

        $columns = (new \App\User)->getTableColumns();
        $downloading_columns = [];

        foreach($columns as $column) {

            if(in_array($column, $request->columns)) {

                $downloading_columns[] = $column;

            }

        }

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $downloading_data = [];
        $users = \App\User::get();

        foreach($users as $user) {

            $downloading_data[] = $user->only($downloading_columns);

        }

        $sheet->fromArray($downloading_data, null, 'A1');
        $filename = 'users.xlsx';
        $writer = new Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="'. $filename .'"');
        $writer->save('php://output');

    }
}
