<html>
<head>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div id="app" class="p-3">
        <h3 class="mb-3">「入荷したらメールでお知らせ」システム・サンプル</h3>
        @if(!auth()->check())
            <div class="alert alert-danger">
                <a href="/login">ログイン</a>してください。
            </div>
        @endif
        <table class="table table-bordered">
            <thead class="bg-secondary text-white">
                <tr>
                    <th class="text-nowrap">商品名</th>
                    <th class="text-nowrap">在庫数</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <tr v-for="i in items">
                    <td class="w-100" v-text="i.name"></td>
                    <td v-text="i.stock"></td>
                    <td class="text-right text-nowrap">
                        <!-- 登録ボタン -->
                        <button
                            type="button"
                            class="btn btn-sm btn-light"
                            v-if="showRegistrationButton(i)"
                            @click="registerNotification(i.id)">入荷したらメールでお知らせ</button>
                        <!-- 解除ボタン -->
                        <button
                            type="button"
                            class="btn btn-sm btn-secondary"
                            v-if="showUnregistrationButton(i)"
                            @click="unregisterNotification(i.id)">お知らせメールを解除</button>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/vue/2.6.11/vue.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.19.2/axios.min.js"></script>
    <script>

        new Vue({
            el: '#app',
            data: {
                items: [],
                userId: parseInt('{{ auth()->user()->id ?? -1 }}')  // ログイン・ユーザーID
            },
            methods: {
                getItems() {

                    axios.get('/ajax/items')
                        .then(response => {

                            this.items = response.data;

                        });

                },
                showRegistrationButton(item) {

                    if(parseInt(item.stock) > 0 || this.userId === -1) {

                        return false;

                    }

                    for(let notification of item.notifications) {

                        if(notification.user_id === this.userId) {

                            return false;

                        }

                    }

                    return true;

                },
                showUnregistrationButton(item) {

                    if(parseInt(item.stock) > 0 || this.userId === -1) {

                        return false;

                    }

                    for(let notification of item.notifications) {

                        if(notification.user_id === this.userId) {

                            return true;

                        }

                    }

                    return false;

                },
                registerNotification(itemId) {

                    const url = '/ajax/items/register_notification';
                    const params = {
                        item_id: itemId
                    };
                    axios.post(url, params)
                        .then(response => {

                            if(response.data.result === true) {

                                alert('お知らせメールの登録が完了しました。');
                                this.getItems();

                            }

                        });

                },
                unregisterNotification(itemId) {

                    const url = '/ajax/items/unregister_notification';
                    const params = {
                        item_id: itemId
                    };
                    axios.post(url, params)
                        .then(response => {

                            if(response.data.result === true) {

                                alert('お知らせメールの解除が完了しました。');
                                this.getItems();

                            }

                        });

                },

            },
            mounted() {

                this.getItems();

            }
        });

    </script>
</body>
</html>
