<?php

namespace App;

use App\Events\ItemSaved;
use Illuminate\Database\Eloquent\Model;

class Item extends Model
{
    protected $dispatchesEvents = [
        'saved' => ItemSaved::class
    ];

    // リレーションシップ
    public function notifications() {

        return $this->hasMany(\App\ItemNotification::class, 'item_id', 'id');

    }
}
