<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class ItemController extends Controller
{
    // ブラウザから
    public function index() {

        return view('items');

    }

    // 以降はAjax
    public function item_list() {

        return \App\Item::with('notifications')->get();

    }

    public function register_notification(Request $request) {

        $result = false;
        $user = $request->user();
        $exists = \App\ItemNotification::where('user_id', $user->id)
            ->where('item_id', $request->item_id)
            ->exists();

        if(!$exists) {

            $notification = new \App\ItemNotification();
            $notification->user_id = $user->id;
            $notification->item_id = $request->item_id;
            $result = $notification->save();

        }

        return ['result' => $result];

    }

    public function unregister_notification(Request $request) {

        $user = $request->user();
        $query = \App\ItemNotification::where('user_id', $user->id)
            ->where('item_id', $request->item_id);

        if($query->exists()) {

            $result = ($query->delete() === 1);

        }

        return ['result' => $result];

    }
}
