<html>
<head>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div id="app" class="p-4">
        <h1 class="mb-3">窓口の受付番号システム・サンプル</h1>
        <div class="bg-light p-3 mb-5">
            ご用件を選んでください。
        </div>
        <div class="row">
            <!-- 受付タイプごとのボタンをつくる ・・・ ① -->
            <div class="col-md-6" v-for="t in receptionTypes">
                <button
                    type="button"
                    class="btn btn-info btn-lg btn-block mb-5 text-bold"
                    style="height:100px;"
                    :disabled="submitting"
                    @click="issueNumberTag(t.id)">
                    <span v-text="t.name"></span>
                    （<span v-text="t.waits_count"></span>人待ち）
                </button>
            </div>
            <div class="col-md-12 text-center" v-if="submitting">
                <h1 class="text-danger text-bold">受付番号をお取りください。</h1>
            </div>
        </div>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/vue/2.6.11/vue.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.19.2/axios.min.js"></script>
    <script>

        new Vue({
            el: '#app',
            data: {
                receptionTypes: [],
                submitting: false
            },
            methods: {
                getTypes() {

                    // reception_typesのデータ取得
                    axios.get('/ajax/reception_type')
                        .then(response => {

                            this.receptionTypes = response.data;

                        });

                },
                issueNumberTag(receptionTypeId) {

                    this.submitting = true;

                    // 選択されたボタンの受付タイプIDを送信してreceptionsデータを追加 ・・・ ②
                    const url = '/ajax/reception';
                    const params = {
                        type_id: receptionTypeId
                    };
                    axios.post(url, params)
                        .then(response => {

                            if(response.data.result === true) {

                                console.log('登録成功！');

                            }

                        })
                        .catch(error => { /* エラー処理 */ })
                        .then(() => {

                            // 受付番号を印刷する時間として5秒待機する
                            setTimeout(() => {

                                this.submitting = false;
                                this.getTypes();

                            }, 5000);

                        });

                }
            },
            mounted() {

                this.getTypes();
                setInterval(() => { // 3秒ごとに受付データを更新する

                    this.getTypes();

                }, 3000);

            }
        });

    </script>
</body>
</html>
