<html>
<head>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div id="app" class="p-4">
        <h1 class="mb-3">受付中のデータ</h1>
        <div class="bg-light p-3 mb-4">
            <small>
                呼び出す： 待機中のお客さんを呼び出す（status: readyへ変更）<br>
                完了： 対応を終了（status: completeへ変更）
            </small>
        </div>
        <table class="table table-striped">
            <thead class="bg-info text-white">
                <tr>
                    <th>受付タイプ</th>
                    <th>受付番号</th>
                </tr>
            </thead>
            <tbody>
                <tr v-for="t in receptionTypes">
                    <td>
                        <span v-text="t.name"></span>
                        （<span v-text="t.waits_count"></span>人待ち）
                    </td>
                    <td>
                        <div style="max-height:300px;overflow-x:hidden;overflow-y:auto;"
                             class="border bg-light border-1 px-3 py-2"
                             v-if="t.waits.length">
                            <div class="row py-2" v-for="w in t.waits">
                                <div class="col-md-3 pl-3">
                                    <h4 v-text="w.reception_number"></h4>
                                </div>
                                <!-- 操作ボタン -->
                                <div class="col-md-9 text-right">
                                    <button
                                        type="button"
                                        class="btn btn-sm btn-link mr-4"
                                        @click="updateStatusTo('complete', w.id)">削除する</button>
                                    <button
                                        type="button"
                                        class="btn btn-info"
                                        @click="updateStatusTo('ready', w.id)"
                                        v-if="w.status=='preparation'">呼び出す</button>
                                    <button
                                        type="button"
                                        class="btn btn-primary"
                                        @click="updateStatusTo('complete', w.id)"
                                        v-if="w.status=='ready'">完了する</button>
                                </div>
                            </div>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/vue/2.6.11/vue.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.19.2/axios.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/lodash.js/4.17.15/lodash.min.js"></script>
    <script>

        new Vue({
            el: '#app',
            data: {
                receptionTypes: []
            },
            methods: {
                getTypes() {

                    // reception_typesのデータ取得
                    axios.get('/ajax/reception_type')
                        .then(response => {

                            this.receptionTypes = response.data;

                        });

                },
                updateStatusTo(status, receptionId) {

                    if(confirm('ステータスを変更します。よろしいですか？')) {

                        // 受付データを変更する
                        const url = '/ajax/reception/'+ receptionId;
                        const params = {
                            id: receptionId,
                            status: status
                        };
                        axios.put(url, params)
                            .then(response => {

                                if(response.data.result === true) {

                                    console.log('変更完了！');
                                    this.getTypes();

                                }

                            });

                    }

                }
            },
            mounted() {

                this.getTypes();
                setInterval(() => { // 3秒ごとに受付データを更新する

                    this.getTypes();

                }, 3000);

            }
        });

    </script>
</body>
</html>
