<?php

namespace App\Events;

use App\Reception;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class ReceptionCreating
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(Reception $reception)
    {
        // 今日の最大受付番号を取得
        $received_on = today()->format('Y-m-d');
        $max_reception_number = \App\Reception::where('received_on', $received_on) // 今日の日付で絞り込み
            ->where('type_id', $reception->type_id) // 同じ受付タイプで絞り込み
            ->max('reception_number');
        $reception->reception_number = intval($max_reception_number) + 1; // 新しい受付番号をセット
        $reception->received_on = $received_on;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('channel-name');
    }
}
