<html>
<head>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div id="app" class="p-4">
        <h1 class="mb-3">お待たせしました</h1>
        <table class="table table-striped">
            <thead class="bg-info text-white">
                <tr>
                    <th>受付タイプ</th>
                    <th>
                        受付番号
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr v-for="t in receptionTypes">
                    <td v-text="t.name"></td>
                    <td>
                        <div v-if="t.readies.length">
                            <h4 v-text="getReceptionNumbers(t.readies).join(',　')"></h4>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/vue/2.6.11/vue.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.19.2/axios.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/lodash.js/4.17.15/lodash.min.js"></script>
    <script>

        new Vue({
            el: '#app',
            data: {
                receptionTypes: []
            },
            methods: {
                getTypes() {

                    // reception_typesのデータ取得
                    axios.get('/ajax/reception_type')
                        .then(response => {

                            this.receptionTypes = response.data;

                        });

                },
                getReceptionNumbers(receptions) {

                    return _.map(receptions, reception => {

                        return reception.reception_number;

                    });

                }
            },
            mounted() {

                this.getTypes();
                setInterval(() => { // 3秒ごとに受付データを更新する

                    this.getTypes();

                }, 3000);

            }
        });

    </script>
</body>
</html>
