<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ReceptionType extends Model
{
    // Relationship
    public function waits() { // 待っているお客さん（現在 + 次の受付データ）

        return $this->hasMany('App\Reception', 'type_id', 'id')
            ->whereIn('status', ['ready', 'preparation']);

    }

    public function readies() { // 対応中のお客さん

        return $this->hasMany('App\Reception', 'type_id', 'id')
            ->whereIn('status', ['ready']);

    }

    private function getToday() {

        return today()->format('Y-m-d');

    }
}
