<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class CustomerController extends Controller
{
    public function create() {

        return view('customer.create');

    }

    public function store(Request $request) {

        // バリデーション
        $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'photos' => 'required',
            'photos.*' => 'image'
        ]);

        // 顧客データ保存
        $customer = new \App\Customer();
        $customer->name = $request->name;
        $customer->email = $request->email;
        $result = $customer->save();

        // ファイル保存
        if($result && $request->hasFile('photos')) {

            foreach($request->photos as $photo) {

                $path = $photo->store('attachments'); // 「storage/app/attachments」フォルダに保存
                $attachment = new \App\Attachment();
                $attachment->parent_id = $customer->id;
                $attachment->model = get_class($customer);
                $attachment->path = $path;
                $attachment->key = 'photos';
                $attachment->save();

            }

        }

        return ['result' => true];

    }

    public function test() {

        // 保存ファイルのデータと連結して取得
        $customers = \App\Customer::with('attachments')->get();

        foreach($customers as $customer) {

            $attachments = $customer->attachments;
            $photos = $attachments->filter(function($attachment){

                return ($attachment->key === 'photos');

            });

            echo $customer->name .'さんの写真（ファイルパス）';

            foreach($photos as $photo) {

                $path = storage_path('app/'. $photo->path); // 保存したファイルのパス
                dump($path);

            }

        }

        /*  削除 */
//        $customer = \App\Customer::first();
//        $customer->delete();

    }

}
