<html>
<body>
    <div id="app">
        <h1>CSVファイルでDBにインポート</h1>
        <label>CSVファイル</label><br>
        <input id="file" type="file" @change="onFileChange">
        <div v-if="csvErrors">
            <ul>
                <li v-for="error in csvErrors" v-text="error"></li>
            </ul>
        </div>
        <br>
        <button type="button" @click="onSubmit">インポートする</button>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/vue@2.6.0"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.19.0/axios.min.js"></script>
    <script>

        new Vue({
            el: '#app',
            data: {
                csvFile: null,
                csvErrors: []
            },
            methods: {
                onFileChange(e) {

                    this.csvFile = e.target.files[0];

                },
                onSubmit() {

                    this.csvErrors = [];

                    const url = '/ajax/csv_import';
                    let formData = new FormData();
                    formData.append('csv_file', this.csvFile);
                    axios.post(url, formData)
                        .then(response => {

                            if(response.data.result) {

                                document.getElementById('file').value = '';
                                alert('インポートが完了しました。');

                            }

                        })
                        .catch(error => {

                            this.csvErrors = error.response.data.errors.csv_file;

                        });

                }
            }
        });

    </script>
</body>
</html>
